/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Map;

public class PairingListPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYSRLT";
    private static final String TRACE_MASKF = "XNTYSRLF";
    private static final String TRACE_MASKD = "XNTYSRLD";
    private transient ItemDescriptor[] m_idPairingListTable;
    private transient ColumnDescriptor[] m_cdPairingListTableStructure;
    private int[] m_iPairingListTableSelection;
    private Map data;
    public static final String DATA_MAP_LINK_NAME = "DataMapLinkName";
    public static final String DATA_MAP_LINK_DESC = "DataMapLinkDesc";
    public static final String DATA_MAP_LINK_ENABLED = "DataMapLinkEnabled";
    public static final String DATA_MAP_LINK_SOURCES = "DataMapLinkSources";
    public static final String DATA_MAP_LINK_SINKS = "DataMapLinkSinks";
    public static final String DATA_MAP_ARRAY = "DataMapArray";
    private static final String PAIRING_TABLE = "PairingTable";
    public static final String TASKLET_SELECTED_LINK = "TaskletSelectedLink";

    public void setPairingListTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        }
        this.m_iPairingListTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "PairingListPanel");
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setDisposed();
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            if (this.m_iPairingListTableSelection == null || this.m_iPairingListTableSelection.length != 1) {
                request = null;
            } else {
                request.setData("CommandName", "EditButton");
                Map[] linkMaps = (Map[])this.data.get(DATA_MAP_ARRAY);
                request.setData(TASKLET_SELECTED_LINK, linkMaps[this.m_iPairingListTableSelection[0]].get(DATA_MAP_LINK_NAME));
            }
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            if (this.m_iPairingListTableSelection == null || this.m_iPairingListTableSelection.length != 1) {
                request = null;
            } else {
                request.setData("CommandName", "DeleteButton");
                Map[] linkMaps = (Map[])this.data.get(DATA_MAP_ARRAY);
                request.setData(TASKLET_SELECTED_LINK, linkMaps[this.m_iPairingListTableSelection[0]].get(DATA_MAP_LINK_NAME));
            }
        }
        if (request != null) {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            String command = (String)map.get("CommandName");
            Map[] linkMaps = (Map[])this.data.get(DATA_MAP_ARRAY);
            if (command.equals("AddButton")) {
                Map[] newLinkMaps = new Map[linkMaps.length + 1];
                System.arraycopy(linkMaps, 0, newLinkMaps, 0, linkMaps.length);
                HashMap newLink = new HashMap();
                newLink.put(DATA_MAP_LINK_NAME, map.get(DATA_MAP_LINK_NAME));
                newLink.put(DATA_MAP_LINK_DESC, map.get(DATA_MAP_LINK_DESC));
                newLink.put(DATA_MAP_LINK_SOURCES, map.get(DATA_MAP_LINK_SOURCES));
                newLink.put(DATA_MAP_LINK_SINKS, map.get(DATA_MAP_LINK_SINKS));
                newLink.put(DATA_MAP_LINK_ENABLED, map.get(DATA_MAP_LINK_ENABLED));
                newLinkMaps[linkMaps.length] = newLink;
                this.data.put(DATA_MAP_ARRAY, newLinkMaps);
            } else if (command.equals("DeleteButton")) {
                Map[] newLinkMaps = new Map[linkMaps.length - 1];
                System.arraycopy(linkMaps, 0, newLinkMaps, 0, this.m_iPairingListTableSelection[0]);
                System.arraycopy(linkMaps, this.m_iPairingListTableSelection[0] + 1, newLinkMaps, this.m_iPairingListTableSelection[0], newLinkMaps.length - this.m_iPairingListTableSelection[0]);
                this.data.put(DATA_MAP_ARRAY, newLinkMaps);
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + PAIRING_TABLE, new int[0]);
                this.setPairingListTableSelection(new int[0]);
            } else if (command.equals("EditButton")) {
                linkMaps[this.m_iPairingListTableSelection[0]].put(DATA_MAP_LINK_NAME, map.get(DATA_MAP_LINK_NAME));
                linkMaps[this.m_iPairingListTableSelection[0]].put(DATA_MAP_LINK_DESC, map.get(DATA_MAP_LINK_DESC));
                linkMaps[this.m_iPairingListTableSelection[0]].put(DATA_MAP_LINK_SOURCES, map.get(DATA_MAP_LINK_SOURCES));
                linkMaps[this.m_iPairingListTableSelection[0]].put(DATA_MAP_LINK_SINKS, map.get(DATA_MAP_LINK_SINKS));
                linkMaps[this.m_iPairingListTableSelection[0]].put(DATA_MAP_LINK_ENABLED, map.get(DATA_MAP_LINK_ENABLED));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        Map[] linkMaps = (Map[])this.data.get(DATA_MAP_ARRAY);
        if (linkMaps == null) {
            this.data.put(DATA_MAP_ARRAY, new Map[0]);
        }
        this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
        this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.m_idPairingListTable = new ItemDescriptor[0];
        this.m_cdPairingListTableStructure = new ColumnDescriptor[0];
        this.m_iPairingListTableSelection = new int[0];
        if (this.data.get(DATA_MAP_ARRAY) == null) {
            this.data.put(DATA_MAP_ARRAY, new Map[0]);
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getPairingListTableRowCount() {
        Map[] linkMaps = (Map[])this.data.get(DATA_MAP_ARRAY);
        return linkMaps.length;
    }

    public ItemDescriptor[] getPairingListTableRowAt(int index) {
        Map[] linkMaps = (Map[])this.data.get(DATA_MAP_ARRAY);
        ItemDescriptor id1 = new ItemDescriptor(this.getMountPrefix() + "name" + index, (String)linkMaps[index].get(DATA_MAP_LINK_NAME));
        ItemDescriptor id2 = new ItemDescriptor(this.getMountPrefix() + "desc" + index, (String)linkMaps[index].get(DATA_MAP_LINK_DESC));
        String[] sources = (String[])linkMaps[index].get(DATA_MAP_LINK_SOURCES);
        String sourceString = "";
        for (int z = 0; z < sources.length - 1; ++z) {
            sourceString = sourceString + sources[z] + ",";
        }
        if (sources.length > 0) {
            sourceString = sourceString + sources[sources.length - 1];
        }
        String[] sinks = (String[])linkMaps[index].get(DATA_MAP_LINK_SINKS);
        String sinkString = "";
        for (int z = 0; z < sinks.length - 1; ++z) {
            sinkString = sinkString + sinks[z] + ",";
        }
        if (sinks.length > 0) {
            sinkString = sinkString + sinks[sinks.length - 1];
        }
        ItemDescriptor id3 = new ItemDescriptor(this.getMountPrefix() + "src" + index, sourceString);
        ItemDescriptor id4 = new ItemDescriptor(this.getMountPrefix() + "sink" + index, sinkString);
        ItemDescriptor id5 = new ItemDescriptor(this.getMountPrefix() + "enabled" + index, ((Boolean)linkMaps[index].get(DATA_MAP_LINK_ENABLED)).toString());
        return new ItemDescriptor[]{id1, id2, id3, id4, id5};
    }

    public ColumnDescriptor[] getPairingListTableRowStructure() {
        return this.m_cdPairingListTableStructure;
    }

    public int getPairingListTableRowStatus() {
        return 3;
    }

    public void setPairingListTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idPairingListTable = items;
    }

    public int[] getPairingListTableSelection() {
        return this.m_iPairingListTableSelection;
    }
}

